// Ajoutez votre code JavaScript ici
const apiKey = "VOTRE_CLE_API"; // Remplacez par votre clé API

function sendMessage() {
    const userInput = document.getElementById("userInput").value;
    const chatDisplay = document.getElementById("chatDisplay");

    // Effectuer une requête API avec la clé
    fetch(`https://api.openai.com/v1/chat/completions`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${apiKey}`,
        },
        body: JSON.stringify({
            messages: [{role: 'user', content: userInput}],
        }),
    })
    .then(response => response.json())
    .then(data => {
        // Afficher la réponse dans la fenêtre de chat
        const modelReply = data.choices[0].message.content;
        chatDisplay.innerHTML += `<p><strong>User:</strong> ${userInput}</p>`;
        chatDisplay.innerHTML += `<p><strong>ChatGPT:</strong> ${modelReply}</p>`;
    })
    .catch(error => console.error('Error:', error));
}
